/**
 * Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential
 */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;

/**
 * Parsing and prepare command line arguments to operation un-register plugin.
 * <p>
 * ./extension-registration -action unregisterPlugin
 * -url <https://IP_OF_THE_VCENTER/sdk/> - required argument, vCenter server IP
 * -username <USERNAME>                  - required argument, vCenter server username
 * -password <PASSWORD>                  - required argument, vCenter server password
 * -key <MY_PLUGIN_KEY>                  - required argument, plugin key
 */
public class UnregisterPluginCmd extends PluginCmd {

   public UnregisterPluginCmd(){
      _action = "-action unregisterPlugin";
      _errorMessage = "Unregister plugin to the VC";
   }

   /**
    * Unregisters a single extension based on the set member fields.
    */
   protected void doExecute() {
      if (_key == null) {
         System.out.println("To unregister a plugin you must provide the key for the plugin\n");
      } else {
         try {
            if (_vimPort.findExtension(_extensionManager, _key) != null) {
               _vimPort.unregisterExtension(_extensionManager, _key);
               System.out.println("Plugin: " + _key + " has been successfully un-registered from vCenter <"+_url+">.");
            } else {
               System.out.println("Plugin: " + _key + " is not registered with vCenter <"+_url+">.");
            }
         } catch (RuntimeFaultFaultMsg e) {
            System.out.println("Exception while finding plugin");
            e.printStackTrace();
         } catch (NotFoundFaultMsg nfe) {
            System.out.println("Exception while un-registering plugin");
            nfe.printStackTrace();
         }
      }
   }

}
